/*****************************************************************************/
/*                         Freescale Semiconductor                           */
/*****************************************************************************/
/* File Type: C Source                                                       */
/* File Name: Colors.c                                                       */
/* Description: Color Convert Functions                                      */
/* Author: Jos Santiago Lpez Ramrez                                       */
/* Date: 29/10/10                                                            */
/* Version: 2.0                                                              */
/*****************************************************************************/

  #include "Colors.h"
  
/*****************************************************************************/
/*                            Functions Definition                           */
/*****************************************************************************/

  UINT8 Convert_888_to_565 (UINT8 Rcomp, UINT8 Gcomp, UINT8 Bcomp, UINT8 ReturnByte)
  {
   UINT32 Conversion_Result;
   UINT8 Color_component;
   
   if(ReturnByte == 1)
   {
    Conversion_Result=(Rcomp*31)/255;
    Rcomp=(UINT8)Conversion_Result;
    Conversion_Result=(Gcomp*63)/255;
    Gcomp=(UINT8)Conversion_Result;
    Rcomp=Rcomp<<3;
    Gcomp=Gcomp>>3;
    Color_component=Rcomp|Gcomp;
   } else
   {
    Conversion_Result=(Bcomp*31)/255;
    Bcomp=(UINT8)Conversion_Result;
    Conversion_Result=(Gcomp*63)/255;
    Gcomp=(UINT8)Conversion_Result;
    Gcomp=Gcomp<<5;
    Color_component=Bcomp|Gcomp;
   }
   return Color_component;   
  }
